#pragma once

#include <maps/libs/geolib/include/point.h>

#include <string>
#include <unordered_map>
#include <map>
#include <set>
#include <list>
#include <unordered_set>
#include <memory>
#include <fstream>

namespace maps {
namespace wiki {
namespace ft_fix {


typedef uint64_t StopId;
typedef std::list<StopId> StopIds;

struct Stop
{
    Stop() = default;

    Stop(StopId id, geolib3::Point2 shape)
        : id(id), shape(shape)
    { }

    StopId id;
    geolib3::Point2 shape;
};
typedef std::unordered_map<StopId, std::shared_ptr<Stop>> Stops;

enum class RouteType
{
    Bus,
    Trolley,
    Tram,
    Minibus
};


struct RouteDescriptor
{
    RouteType type;
    std::string name;
    bool operator < (const RouteDescriptor&) const;
    bool operator ==(const RouteDescriptor&) const;
};

struct Route
{
    RouteDescriptor descr;
    StopIds stopIds;
    bool operator < (const Route&) const;
};

typedef std::set<Route> Routes;

typedef std::map<RouteDescriptor, StopIds> StopsByRoute;


class RoutesData
{
public:
    RoutesData(std::ifstream& ifs);

    Routes clusterize(double thresholdMeters) const;

private:
    void parseRoutes(StopId, RouteType, const std::string&);
    StopIds collectNeighbors(StopId curStop, StopIds& stops, double thresholdMeters) const;
    bool isNeighbors(const geolib3::Point2&, const geolib3::Point2&, double thresholdMeters) const;
    Routes clusterizeRoute(const RouteDescriptor&, StopIds, double) const;

private:
    StopsByRoute stopsByRoute;
    Stops stops;
};

} // namespace ft_fix
} // namespace wiki
} // namespace maps
