-- all named objects in Kirim
drop table if exists kirim_id;
create table kirim_id
(
id bigint NOT NULL,
table_name text NOT NULL
);

-- AD (Kirim+Sevastopol, and all theis children to the fifth generation
insert into kirim_id 
select ad.ad_id as id, 'ad' as table_name  from ad
left join ad as ad2 on ad2.ad_id = ad.p_ad_id
left join ad as ad3 on ad3.ad_id = ad2.p_ad_id
left join ad as ad4 on ad4.ad_id = ad3.p_ad_id
left join ad as ad5 on ad5.ad_id = ad4.p_ad_id
left join ad as ad6 on ad6.ad_id = ad5.p_ad_id
where
ad.ad_id in (28,9)
or ad2.ad_id in (28,9)
or ad3.ad_id in (28,9)
or ad4.ad_id in (28,9)
or ad5.ad_id in (28,9)
or ad6.ad_id in (28,9) ;

-- RD
insert into kirim_id 
select rd.rd_id as id, 'rd' as table_name  from rd
left join rd_ad on rd.rd_id = rd_ad.rd_id
where
rd_ad.ad_id in (select id from kirim_id where table_name='ad');

-- FT
insert into kirim_id 
select ft.ft_id as id, 'ft' as table_name  from ft
left join ft_ad on ft.ft_id = ft_ad.ft_id
where
ft_ad.ad_id in (select id from kirim_id where table_name='ad');

-- ADDR
insert into kirim_id 
select addr.addr_id as id, 'addr' as table_name  from addr
where
ad_id in (select id from kirim_id where table_name='ad')
or rd_id in (select id from kirim_id where table_name='rd')
or ft_id in (select id from kirim_id where table_name='ft');

-- set local flag to true for russian names

-- AD
update ad_nm SET is_local=true
where lang='ru'
and script is null
and ad_id in (select id from kirim_id where table_name='ad');

-- RD
update rd_nm SET is_local=true
where lang='ru'
and script is null
and rd_id in (select id from kirim_id where table_name='rd');

-- FT
update ft_nm SET is_local=true
where lang='ru'
and script is null
and ft_id in (select id from kirim_id where table_name='ft');

-- ADDR
update addr_nm SET is_local=true
where lang='ru'
and script is null
and addr_id in (select id from kirim_id where table_name='addr');

drop table if exists kirim_id;
