import yt.wrapper as yt

TABLES_PATH = '//home/maps/core/nmaps/analytics/poi-stat/raw'

NEW_SCHEMA = [
    {'name': 'dist', 'type_v3': {'type_name': 'optional', 'item': 'double'}},
    {'name': 'ft_id', 'type_v3': {'type_name': 'optional', 'item': 'int64'}},
    {'name': 'ft_type_id', 'type_v3': 'int64'},
    {'name': 'geom_altay', 'type_v3': {'type_name': 'optional', 'item': 'utf8'}},
    {'name': 'geom_nk', 'type_v3': 'string'},
    {'name': 'is_closed', 'type_v3': {'type_name': 'optional', 'item': 'bool'}},
    {'name': 'permalink_id', 'type_v3': {'type_name': 'optional', 'item': 'utf8'}},
    {'name': 'position_alignment', 'type_v3': {'type_name': 'optional', 'item': 'int64'}},
    {'name': 'position_quality', 'type_v3': {'type_name': 'optional', 'item': 'int64'}},
    {'name': 'region_id', 'type_v3': {'type_name': 'optional', 'item': 'utf8'}},
]


def main():
    yt_client = yt.YtClient(proxy='hahn')
    # dates = yt_client.list(TABLES_PATH)
    dates = ['2021-11-09']
    for date in dates:
        table_path = yt.ypath.ypath_join(TABLES_PATH, date)
        print('Processing', table_path)

        rows = []
        for row in yt_client.read_table(table_path):
            if row['location_entrance'] or row['location_sign']:
                row['position_alignment'] = 1
            elif row['location_indoor']:
                row['position_alignment'] = 2
            else:
                row['position_alignment'] = 0
            del row['location_entrance']
            del row['location_sign']
            del row['location_indoor']
            rows.append(row)

        new_table_path = table_path.replace('raw', 'raw-new')
        print('Writing to', new_table_path)
        yt.write_table(yt.TablePath(new_table_path, attributes={'schema': NEW_SCHEMA}), rows)
        print('Table processed')
