#pragma once

#include <unordered_set>

namespace maps::garden::modules::renderer_denormalization {

// https://wiki.openstreetmap.org/wiki/Key:piste:difficulty
// https://yandexteam-my.sharepoint.com/:x:/g/personal/avlasyuk_yandex-team_ru/Edoio7ke2SlDpEcmfQxdcNoB0mB6m-i0E4UCAmLj0PcCfg

// clang-format off

// When adding new IDs, sort the lists in alphabetical order.

// novice
inline const std::unordered_set<size_t> PISTE_GREEN_IDS = {
    1537597126,
    1617080899,
    1617083919,
    1623214929,
    1623215245,
    1630101660,
    1630172620,
    1631642940,
    1633252171,
    1634075150,
    1639547760,
    1639553520,
    1640041140,
    1640228400,
    1640228410,
    1649376702,
    1649376792,
    1649377111,
    1653662971,
    1664796281,
    1665493401,
    1668104132,
    1668104372,
    1668106332,
    1713943320,
    1889171651,
    1889274291,
    1892639331,
    1894045491,
    1894479721,
    1894519251,
    1894568091,
    1894648411,
    1894982891,
    1894983781,
    1894984181,
    1912180031,
    1912181181,
    2026965166,
    2026971196,
    2077157702,
    2106071601,
    2106081431,
    2111201327,
    2111226917,
    2111273607,
    2111359107,
    2114457809,
    2114624439,
    2119335101,
    2133619508,
    2134613738,
    2134631248,
    2134634728,
    2134655728,
    2136424148,
    2196446689,
    2237243641,
    2495369526,
    2495369886,
    2495371306,
    2495371866,
    2498461671,
    2498462336,
    2498465776,
    2498471667,
    2498473726,
    2498486686,
    2498486966,
    3258618617,
    3260666177,
    3358291085,
    3386233915,
    3496718535,
    3620240724,
    3620241994,
    3798780610,
    3819314930,
    3820619600,
    3852068630,
    3852133530,
    3902489050,
    4066526935,
    4066527665,
    4143730326,
    4156290161,
    4156840436,
    4159282636,
    4159282876,
    4159283026,
    4163174009,
    4163174014,
    4174826053,
    4180948803,
    4183984313,
    4183998233,
    4186416333,
    4186425348,
    4186968893,
    4187483043,
    4187491723,
    4187534499,
    4187923773,
    4187924663,
    4187931703,
    4188685433,
    4196818133,
    4196818513,
    4202327593,
    4215269589,
    4223372421,
    4223706549,
    4250556009,
    4257374759,
    4257420969,
    4257608139,
    4259548419,
    4260795949,
    4260807189,
    4261601939,
    4261705219,
    4261710529,
    4261711029,
    4261727209,
    4261820159,
    4268411019,
    4271987489,
    4273014059,
    4273116839,
    4275263764,
    4275426559,
    4275430119,
    4275443299,
    4276635439,
    4277313469,
    4277340039,
    4277344169,
    4277345019,
    4277920869,
    4277935479,
    4279640169,
    4279667699,
    4279667939,
    4279674429,
    4279676629,
    4280356869,
    4280356909,
    4282423689,
    4282530101,
    4283923639,
    4283941129,
    4284831329,
    4284833329,
    4284833759,
    4285374039,
    4285375069,
    4285379819,
    4285398079,
    4286017059,
    4286017239,
    4286018279,
    4287494929,
    4287495609,
    4287595629,
    4287613729,
    4287685709,
    4287696949,
    4287721769,
    4287840019,
    4287851689,
    4288536819,
    4288587099,
    4289096929,
    4289097539,
    4289097969,
    4289821629,
    4303749498,
    4303749938,
    4303772438,
    4304794348,
    4304845738,
    4363685806,
    4375069276,
    4375122826,
    4376168356,
    4376169446,
    4376171536,
    4376179816,
    4379558460,
    4385335700,
    4385382660,
    4386244560,
    4386500070,
    4386637200,
    4386637640,
    4387232000,
    4387437600,
    4387438960,
    4387588572,
    4388680040,
    4390737262,
    4391954445,
    4391974660,
    4392028490,
    4392091654,
    4392095580,
    4392095585,
    4394308310,
    4394335310,
    4394344360,
    4394347180,
    4394347890,
    4394351150,
    4394388160,
    4394437780,
    4394458820,
    4394475090,
    4394502060,
    4394566250,
    4394571470,
    4394574630,
    4397578920,
    4397816750,
    4398763080,
    4398765660,
    4398766850,
    4398767470,
    4398863650,
    4399391340,
    4410911330,
    4411129060,
    4411407380,
    4411465640,
    4411480540,
    4412046660,
    4412166480,
    4419558080,
    4437564160,
    4437566290,
    4437836870,
    4437885560,
    4437993420,
    4438017380,
    4438847100,
    4438847600,
    4438873540,
    4438932570,
    4439661490,
    4439698570,
    4439709280,
    4448368610,
    4448375140,
    4449604740,
    4449699970,
    4450380830,
    4450392460,
    4450392980,
};

// easy
inline const std::unordered_set<size_t> PISTE_BLUE_IDS = {
    1505901900,
    1537597132,
    1537597134,
    1617083529,
    1617083599,
    1617083729,
    1617102749,
    1617103449,
    1617105259,
    1623212999,
    1623213625,
    1630101190,
    1630102530,
    1630171660,
    1631643350,
    1631643600,
    1633195860,
    1634076110,
    1639551742,
    1639552660,
    1639554190,
    1640041610,
    1640041830,
    1640041910,
    1640042320,
    1640227420,
    1640227460,
    1640227480,
    1641897191,
    1641905431,
    1653630261,
    1653634161,
    1653635261,
    1653636221,
    1653638851,
    1664795541,
    1664795641,
    1664825921,
    1668103452,
    1713943230,
    1889172251,
    1889275991,
    1889277181,
    1892575331,
    1892575511,
    1892595917,
    1892639901,
    1892640181,
    1894043821,
    1894045061,
    1894481351,
    1894519811,
    1894520261,
    1894566061,
    1894597961,
    1894599991,
    1894600681,
    1894646631,
    1894647011,
    1894982721,
    2026965826,
    2026966866,
    2026967086,
    2056431282,
    2056431285,
    2106129321,
    2106234468,
    2107986447,
    2108043707,
    2108064567,
    2108071907,
    2108106277,
    2108113247,
    2108732837,
    2108740237,
    2108748947,
    2108894177,
    2111187937,
    2111188967,
    2111228487,
    2111267187,
    2111271067,
    2111272917,
    2111289937,
    2111358277,
    2111387597,
    2111388117,
    2111388547,
    2111390837,
    2111391517,
    2114283259,
    2114474529,
    2114519909,
    2116239999,
    2133572248,
    2133887298,
    2134511848,
    2134586398,
    2134621628,
    2489125926,
    2495373496,
    2496104346,
    2496105586,
    2496107336,
    2496107946,
    2496109636,
    2498459846,
    2498460676,
    2498463206,
    2498463211,
    3169070127,
    3258435067,
    3258440787,
    3258451127,
    3258461937,
    3258590107,
    3258601507,
    3258605457,
    3258612547,
    3258615387,
    3258624207,
    3260672857,
    3260683567,
    3752534460,
    3798778290,
    3798780030,
    3809827651,
    3811218670,
    3852081340,
    3852108210,
    3852116350,
    3852140750,
    3882518380,
    3902439120,
    3902455700,
    3902489740,
    3938683100,
    3938683980,
    3938686500,
    3984960270,
    4084844550,
    4159280706,
    4159281046,
    4159281506,
    4159281926,
    4159283226,
    4159283526,
    4159283916,
    4159284256,
    4159284336,
    4159284846,
    4159285256,
    4159285446,
    4159285546,
    4163163681,
    4163170969,
    4163170973,
    4163171339,
    4163171489,
    4163175249,
    4164451719,
    4174824873,
    4174825403,
    4180946433,
    4180950003,
    4181513053,
    4181518073,
    4181521223,
    4181523813,
    4181566243,
    4181586663,
    4181591493,
    4183988223,
    4186417313,
    4186425494,
    4187490603,
    4187497353,
    4187521303,
    4187924913,
    4187925693,
    4187926463,
    4187927503,
    4187929183,
    4188681283,
    4207479813,
    4207480383,
    4214565973,
    4214566903,
    4214568853,
    4215267679,
    4222944979,
    4230652339,
    4230653479,
    4235970169,
    4250370859,
    4250371019,
    4250386370,
    4250391569,
    4250391909,
    4251098639,
    4253445359,
    4257402749,
    4257403689,
    4257417679,
    4259550599,
    4259621561,
    4259622220,
    4259623153,
    4259624311,
    4259624480,
    4261604069,
    4261605329,
    4261709659,
    4261832939,
    4261833739,
    4261834739,
    4261835039,
    4262203769,
    4268411419,
    4268411479,
    4269045739,
    4271987979,
    4271988109,
    4273010969,
    4273014159,
    4273176059,
    4273176219,
    4275430799,
    4275431139,
    4275431469,
    4275431759,
    4275441169,
    4275441539,
    4275442219,
    4275715089,
    4275715149,
    4275715229,
    4275715319,
    4275715409,
    4276635099,
    4276635209,
    4277314169,
    4277951699,
    4278007599,
    4278012809,
    4278013519,
    4283936559,
    4283936919,
    4284832359,
    4285360919,
    4285364849,
    4285365719,
    4285371329,
    4285376479,
    4287495259,
    4287599639,
    4287599859,
    4287600169,
    4287613479,
    4287659059,
    4287659063,
    4287681839,
    4287685069,
    4287694449,
    4287698859,
    4287699649,
    4287700529,
    4287723839,
    4287724119,
    4287771499,
    4287771879,
    4287771979,
    4287772609,
    4287772929,
    4287773069,
    4287773279,
    4287815189,
    4287815539,
    4287816349,
    4287822829,
    4287830179,
    4288578609,
    4288581689,
    4288931219,
    4289807969,
    4289809389,
    4289810069,
    4289811489,
    4289822589,
    4290066499,
    4303772608,
    4303772748,
    4304860598,
    4333734830,
    4333736150,
    4333736850,
    4375072266,
    4375076166,
    4375120326,
    4375120646,
    4376151186,
    4376151956,
    4376154406,
    4376163996,
    4376166486,
    4376166826,
    4376194366,
    4376199876,
    4385316892,
    4385336520,
    4385337050,
    4385376540,
    4385377090,
    4385377580,
    4385381220,
    4386243570,
    4386243860,
    4386245430,
    4386245820,
    4386246900,
    4386636490,
    4387224822,
    4387231330,
    4387363560,
    4387363990,
    4387365630,
    4387366110,
    4387416840,
    4387442270,
    4387443200,
    4391932810,
    4391933210,
    4391946420,
    4391980000,
    4392001460,
    4392006820,
    4392009900,
    4392013670,
    4392092700,
    4392094840,
    4394310140,
    4394310630,
    4394342600,
    4394348260,
    4394348640,
    4394349230,
    4394353280,
    4394511550,
    4394517640,
    4394523120,
    4394568430,
    4397808200,
    4398521890,
    4398523030,
    4398933960,
    4398954030,
    4399266820,
    4399352430,
    4399368440,
    4399368650,
    4399368870,
    4404578500,
    4404727200,
    4405397130,
    4406582640,
    4406609380,
    4406628120,
    4410919080,
    4411120760,
    4411481640,
    4412167350,
    4412167700,
    4413931570,
    4413932030,
    4413933160,
    4413933360,
    4419558880,
    4419563430,
    4437561650,
    4437567310,
    4437567640,
    4437831190,
    4437832630,
    4437857680,
    4437883080,
    4437889640,
    4437897420,
    4437992880,
    4438018030,
    4438927360,
    4439678250,
    4439679250,
    4439705240,
    4442189600,
    4448375570,
    4448380650,
    4448399710,
    4448400460,
    4450358970,
    4450368300,
    4450397210,
    4450483860,
    4450484370,
    4450520292,
    4470346570,
    4493075690,
};

// intermediate
inline const std::unordered_set<size_t> PISTE_RED_IDS = {
    1537597128,
    1537602782,
    1617103259,
    1617104259,
    1617106609,
    1623212450,
    1627422239,
    1627422299,
    1627422459,
    1630102000,
    1630171200,
    1630173910,
    1630177420,
    1630177650,
    1631643930,
    1633196320,
    1634072150,
    1634072320,
    1634072690,
    1634072970,
    1634370310,
    1634370870,
    1634371600,
    1634372140,
    1639547820,
    1639548680,
    1639553030,
    1639553700,
    1640042060,
    1640227410,
    1640228590,
    1640228890,
    1641908601,
    1649376702,
    1649376792,
    1653624311,
    1664796061,
    1664796401,
    1664825081,
    1664825621,
    1665492031,
    1665493711,
    1668100472,
    1668102712,
    1713943440,
    1889170451,
    1889272311,
    1889273521,
    1889276841,
    1892575121,
    1892600547,
    1892606801,
    1892639631,
    1892640181,
    1894044061,
    1894044231,
    1894044381,
    1894044751,
    1894044911,
    1894474851,
    1894476311,
    1894477491,
    1894490241,
    1894492561,
    1894495841,
    1894497111,
    1894498421,
    1894569021,
    1894599161,
    1894647361,
    1894648341,
    1894983291,
    1912178041,
    2026966446,
    2026967566,
    2106247458,
    2106267068,
    2106273098,
    2108014677,
    2108015547,
    2108015917,
    2108022947,
    2108767537,
    2108890707,
    2108897417,
    2111204607,
    2111211067,
    2111213197,
    2111229517,
    2111231147,
    2111266047,
    2111270357,
    2111281047,
    2111350167,
    2111350507,
    2111351427,
    2111353207,
    2111355957,
    2111365907,
    2111366447,
    2111378817,
    2111379777,
    2111383247,
    2113820863,
    2113835503,
    2113836293,
    2113847563,
    2114433649,
    2114491079,
    2114635889,
    2116241639,
    2116242659,
    2134518838,
    2472131223,
    2472132033,
    2472135473,
    2495367616,
    2495368416,
    2495376036,
    2496062666,
    2498461666,
    2498464186,
    2498465766,
    2498465771,
    2498474796,
    2498476146,
    3169071797,
    3169072957,
    3258415227,
    3258427587,
    3258432027,
    3258444117,
    3258597627,
    3258650597,
    3260690187,
    3260694727,
    3260707237,
    3620228154,
    3798779120,
    3798782660,
    3809827151,
    3809827381,
    3809827556,
    3809832871,
    3842848530,
    3842852180,
    3842858310,
    3842869450,
    3842878500,
    3842880280,
    3843495530,
    3843513480,
    3843514580,
    3852073190,
    3852079060,
    3852084150,
    3852088730,
    3852101350,
    3852113230,
    3852118080,
    3852124400,
    3882518700,
    3902396770,
    3902399970,
    3902433870,
    3984959060,
    3984959340,
    3984959930,
    4066525355,
    4066526645,
    4127741292,
    4143716936,
    4143722846,
    4143724176,
    4159281156,
    4159284146,
    4159285676,
    4163160899,
    4163161129,
    4163170779,
    4164451219,
    4174826683,
    4180955483,
    4181520153,
    4181520353,
    4181560183,
    4181561083,
    4181570593,
    4181570833,
    4181585783,
    4183992993,
    4186414303,
    4186415383,
    4186982713,
    4187007703,
    4187017013,
    4187017703,
    4187486593,
    4187494863,
    4187542673,
    4187925463,
    4187929373,
    4187930933,
    4187944813,
    4188680723,
    4195327923,
    4215264419,
    4215265069,
    4215266789,
    4223706839,
    4230654249,
    4230654859,
    4257359369,
    4257398619,
    4257402579,
    4257421889,
    4257422849,
    4257427869,
    4257605539,
    4257607249,
    4257607529,
    4259407229,
    4259438189,
    4259550909,
    4259621561,
    4259621791,
    4261606049,
    4261606489,
    4268411549,
    4269042479,
    4269043039,
    4269045229,
    4273010539,
    4275264454,
    4275437959,
    4275438569,
    4275438899,
    4275714669,
    4276634909,
    4277313359,
    4277314459,
    4278006749,
    4278008679,
    4278009159,
    4278015749,
    4279665569,
    4279666009,
    4279666339,
    4279667009,
    4280357129,
    4283867659,
    4283877939,
    4283927019,
    4283937649,
    4283938129,
    4283942149,
    4283942559,
    4284831879,
    4285337059,
    4285362870,
    4285363259,
    4285363569,
    4285367649,
    4287609409,
    4287680709,
    4287684869,
    4287723049,
    4287771369,
    4287772609,
    4287772739,
    4288579269,
    4288581199,
    4288930619,
    4303742328,
    4304860228,
    4367494736,
    4375074906,
    4375076856,
    4376152616,
    4376192586,
    4376199416,
    4376204756,
    4376212416,
    4385337640,
    4385375880,
    4385380490,
    4386634460,
    4386635910,
    4387253710,
    4387280982,
    4387281971,
    4387282510,
    4387363060,
    4387364570,
    4387365070,
    4387418030,
    4387587772,
    4387587982,
    4387588682,
    4388680180,
    4390736292,
    4391900000,
    4391943162,
    4391943170,
    4391944402,
    4391945900,
    4391978640,
    4393026740,
    4394311580,
    4394312160,
    4394347720,
    4394350410,
    4394350830,
    4394352260,
    4394352740,
    4394352830,
    4394355110,
    4394356460,
    4394470350,
    4394496620,
    4394502780,
    4394505580,
    4394507340,
    4394570240,
    4397566220,
    4397809050,
    4397809720,
    4398520620,
    4398952840,
    4399366930,
    4399367620,
    4405396550,
    4406583630,
    4410912970,
    4411138810,
    4411406570,
    4411432780,
    4412166700,
    4412166930,
    4412167960,
    4413929302,
    4413932530,
    4413933790,
    4419561740,
    4419562800,
    4437568040,
    4437568240,
    4437569240,
    4437570590,
    4437865750,
    4438020340,
    4438873230,
    4438879420,
    4438895520,
    4439696220,
    4439705830,
    444837608,
    4450367310,
    4450369620,
    4450519730,
    4450562870,
    4470348370,
};

// advanced
inline const std::unordered_set<size_t> PISTE_BLACK_IDS = {
    1537597142,
    1537602778,
    1537602780,
    1617102949,
    1617104409,
    1617104669,
    1617104839,
    1617105469,
    1617112669,
    1630173580,
    1631642780,
    1634371410,
    1634372420,
    1640228950,
    1664796711,
    1665492201,
    1862806771,
    1894472311,
    1894484121,
    1894983551,
    2108068107,
    2108756587,
    2108895137,
    2108897927,
    2111185667,
    2111188967,
    2111264617,
    2111281997,
    2111362897,
    2111363737,
    2111364057,
    2116643388,
    2125892880,
    2197735229,
    2197735469,
    2472134363,
    2472171633,
    2495366946,
    2495377626,
    2498471206,
    3169073977,
    3258455937,
    3258586637,
    3258613417,
    3258638257,
    3258663227,
    3258808337,
    3260700137,
    3358314015,
    3358319695,
    3620210164,
    3620237004,
    3842850090,
    3842868640,
    3842870740,
    3842873030,
    3852085970,
    3852087620,
    3852090170,
    3902435760,
    3902449010,
    3938683390,
    3938685710,
    3938686630,
    3984950100,
    4066525545,
    4066526375,
    4164450889,
    4180953133,
    4181519433,
    4181574863,
    4181575813,
    4181577053,
    4183999843,
    4186413043,
    4186413743,
    4187927733,
    4187928823,
    4215267389,
    4215268029,
    4250391199,
    4257346929,
    4257403209,
    4257429169,
    4257429979,
    4257431119,
    4257432839,
    4257443519,
    4257603129,
    4259432229,
    4259433759,
    4259551569,
    4261214640,
    4261214643,
    4261601379,
    4269042479,
    4269044289,
    4275439129,
    4276634609,
    4277937739,
    4278007109,
    4278010369,
    4278011489,
    4278014979,
    4287680999,
    4304861148,
    4333737590,
    4375051276,
    4385339100,
    4385372990,
    4385379490,
    4387254370,
    4387416170,
    4391996330,
    4392006230,
    4392019440,
    4392023400,
    4392026020,
    4392026830,
    4394345850,
    4394353790,
    4394396780,
    4394437020,
    4394437230,
    4394573410,
    4394575940,
    4394576630,
    4397568030,
    4398521430,
    4398523600,
    4405396840,
    4410922840,
    4437565650,
    4437569670,
    4437570240,
    4438024220,
    4438037450,
    4439711280,
    4442190200,
    4450371280,
    4450374660,
};

// expert
inline const std::unordered_set<size_t> PISTE_DOTTED_BLACK_IDS = {
    2106291368,
    2107887537,
    2113843993,
    2133781778,
};

inline const std::unordered_set<size_t> PISTE_TUBING_IDS = {
    1617105759,
    1640306530,
    1653624031,
    1716769240,
    1892602243,
    1892609811,
    2224208401,
    2496109636,
    2498487516,
    3381977005,
    3620241404,
    3798783870,
    3820620970,
    3984960490,
    4066528525,
    4185672193,
    4187485323,
    4196831023,
    4215274759,
    4215275209,
    4215275419,
    4219354549,
    4253448181,
    4261209419,
    4261612729,
    4273182509,
    4275265241,
    4275426119,
    4276638159,
    4276638849,
    4277323459,
    4277346179,
    4277931899,
    4278025079,
    4283925709,
    4283943909,
    4285380989,
    4287712379,
    4287810179,
    4288585529,
    4290069069,
    4290069899,
    4304854038,
    4343019290,
    4386248090,
    4386633912,
    4386637940,
    4387223170,
    4387225811,
    4387232630,
    4387418800,
    4388682780,
    4392104202,
    4392104392,
    4392113280,
    4392113700,
    4394367910,
    4394368810,
    4394370940,
    4394399010,
    4394402880,
    4394476450,
    4394583790,
    4394584040,
    4394584690,
    4397757750,
    4397812830,
    4398777850,
    4398779060,
    4398938020,
    4399267460,
    4400594560,
    4406598260,
    4411411890,
    4416366740,
    4437563120,
    4437565820,
    4437838400,
    4437875230,
    4437999560,
    4438029450,
    4450550510,
};

inline const std::unordered_set<size_t> PISTE_SNOWPARK_IDS = {
    1649378541,
    1889277761,
    3126379817,
    394509010,
    4159285756,
    4288931609,
    4376107136,
    4376141656,
    4376906486,
    4387590512,
    4391931650,
    4392029580,
    4392103892,
    4392112030,
    4394359670,
    4394470350,
    4394509010,
    4394524190,
    4394525760,
    4398764410,
    4398782930,
};

// clang-format on
} // namespace maps::garden::modules::renderer_denormalization
