#include <maps/libs/cmdline/include/cmdline.h>
#include <maps/libs/common/include/exception.h>
#include <maps/libs/common/include/file_utils.h>
#include <maps/libs/log8/include/log8.h>

#include <maps/wikimap/mapspro/tools/junk/toloka_downloader/lib/image_utils.h>


int main(int argc, char** argv) try {

    maps::cmdline::Parser argsParser;
    auto inputFile = argsParser.file("input-file")
        .help("Path to input image")
        .required();

    auto outputFile = argsParser.file("output-file")
        .help("Path to output image")
        .required();

    auto scale = argsParser.size_t("scale")
        .help("Scale to shrink image (2 -> w/2, h/2)")
        .defaultValue(2);

    argsParser.parse(argc, argv);

    INFO() << "Input file: " << inputFile;
    INFO() << "Output file: " << outputFile;
    const auto inputData = maps::common::readFileToString(inputFile);
    INFO() << "Input file size: " << inputData.size();

    const auto outputData = maps::wiki::toloka::shrinkImage(inputData, scale);
    INFO() << "Output file size: " << outputData.size();
    maps::common::writeFile(outputFile, outputData);

    return EXIT_SUCCESS;
} catch (const maps::Exception& e) {
    FATAL() << "Exception caught: " << e;
    return EXIT_FAILURE;
} catch (const std::exception& ex) {
    FATAL() << "Exception caught: " << ex.what();
    return EXIT_FAILURE;
} catch (...) {
    FATAL() << "Unknown exception caught";
    return EXIT_FAILURE;
}
