#include "assignment.h"

#include <maps/libs/common/include/exception.h>
#include <maps/wikimap/mapspro/libs/common/include/yandex/maps/wiki/common/string_utils.h>

namespace maps::wiki::toloka {

namespace {
const std::string EMPTY;
} //namespace

const Assignment::Id& Assignment::id() const
{
    const auto& value = get("assignment_assignment_id");
    REQUIRE(!value.empty(), "Assignment id not found");
    return value;
}

void Assignment::add(const std::string& key, std::string value)
{
    ASSERT(data_.try_emplace(key, std::move(value)).second);
}

const std::string& Assignment::get(const std::string& key) const
{
    auto it = data_.find(key);
    return it != data_.end() ? it->second : EMPTY;
}

const std::string& Assignment::status() const
{
    return get("assignment_status");
}

AttachmentIds Assignment::attachmentIds() const
{
    static const std::vector<std::string> PHOTO_KEYS {
        "output_address_photo",
        "output_building_photo",
        "output_sign_photo",
        "output_sign_photo_without_plate",
        "output_sign_photo_with_plate",
    };

    AttachmentIds result;
    for (const auto& key : PHOTO_KEYS) {
        for (auto&& id : common::split(get(key), ",")) {
            if (!id.empty()) {
                result.emplace_back(std::move(id));
            }
        }
    }
    return result;
}

} // namespace maps::wiki::toloka
