#pragma once

#include "assignment.h"
#include "common.h"

#include <maps/wikimap/mapspro/libs/common/include/yandex/maps/wiki/common/extended_xml_doc.h>
#include <maps/wikimap/mapspro/libs/common/include/yandex/maps/wiki/common/pgpool3_helpers.h>

#include <map>

namespace maps::wiki::toloka {

class Database
{
public:
    Database(const common::ExtendedXmlDoc& config, ProjectId projectId);

    bool saveAssignment(
        PoolId poolId,
        const Assignment& assignment);

    std::map<AttachmentId, PhotoId> loadSavedPhotoIds(
        const Assignment& assignment);

    bool saveAttachments(
        const Assignment& assignment,
        const std::map<AttachmentId, PhotoId>& attachmentToPhotoIds);

    pgpool3::Pool& socialPool() { return socialPool_.pool(); }

private:
    wiki::common::PoolHolder socialPool_;
    ProjectId projectId_;
};

} // namespace maps::wiki::toloka
