#pragma once

#include "action.h"
#include "client.h"
#include "database.h"
#include "mrc_client.h"

#include <maps/wikimap/mapspro/libs/common/include/yandex/maps/wiki/common/extended_xml_doc.h>

#include <set>
#include <string>

namespace maps::wiki::toloka {

class Worker
{
public:
    Worker(
        const common::ExtendedXmlDoc& config,
        const std::string& tvmAlias,
        const Client& client);

    bool run(
        const std::set<Action>& actions,
        PoolId poolId);

    const Client& client() const { return client_; }
    Database& database() { return db_; }

private:
    Database db_;
    MrcClient mrcClient_;
    const Client& client_;
};

} // namespace maps::wiki::toloka
