CREATE SCHEMA IF NOT EXISTS toloka;

CREATE TABLE IF NOT EXISTS toloka.assignment (
    assignment_id text PRIMARY KEY,
    project_id bigint NOT NULL,
    pool_id bigint NOT NULL,
    created_at timestamp with time zone NOT NULL DEFAULT NOW(),

    assignment_accepted text,
    assignment_assignment_id text,
    assignment_expired text,
    assignment_link text,
    assignment_rejected text,
    assignment_reward text,
    assignment_skipped text,
    assignment_started text,
    assignment_status text,
    assignment_submitted text,
    assignment_task_id text,
    assignment_task_suite_id text,
    assignment_worker_id text,
    input_address_ru text,
    input_coordinates text,
    input_country text,
    input_language text,
    input_meta text,
    input_perimeter text,
    input_point_id text,
    input_task_id text,
    output_address_photo text,
    output_building_photo text,
    output_comment text,
    output_sign_photo text,
    output_verdict text,
    output_worker_coordinates text,
    output_photopoint text,
    output_sign_photo_without_plate text,
    output_sign_photo_with_plate text
);

CREATE INDEX IF NOT EXISTS assignment_pool_id_idx
    ON toloka.assignment USING btree (pool_id);

CREATE TABLE IF NOT EXISTS toloka.assignment_photo (
    assignment_id text REFERENCES toloka.assignment(assignment_id) NOT NULL,
    attachment_id text NOT NULL,
    photo_id text NOT NULL UNIQUE,
    created_at timestamp with time zone NOT NULL DEFAULT NOW(),

    PRIMARY KEY (assignment_id, attachment_id)
);
