import argparse
import json
import smtplib
from email.mime.application import MIMEApplication
from email.mime.multipart import MIMEMultipart
from email.mime.text import MIMEText
from email.utils import COMMASPACE, formatdate
from os.path import basename


def load_file(filename, mode="r"):
    with open(filename, mode) as f:
        return f.read()


def make_message(config, sender, receivers, cc_receivers):
    message = MIMEMultipart("mixed")
    message["From"] = sender
    message["To"] = COMMASPACE.join(receivers)
    if len(cc_receivers) > 0:
        message["Cc"] = COMMASPACE.join(cc_receivers)
    message["Date"] = formatdate(localtime=True)
    message["Subject"] = load_file(config["subject-file"]).strip()
    message.attach(MIMEText(load_file(config["text-file"]), "plain"))

    for f in config.get("attachments", []):
        part = MIMEApplication(load_file(f, "rb"), name=basename(f))
        part["Content-Disposition"] = 'attachment; filename="%s"' % basename(f)
        message.attach(part)
    return message


def run(config):
    sender = config["from"]
    receivers = config["to"]
    cc_receivers = config["cc"]
    message = make_message(config, sender, receivers, cc_receivers)
    with smtplib.SMTP(config["outbound-relay-host"]) as conn:
        conn.sendmail(sender, receivers + cc_receivers, message.as_string())


def main():
    parser = argparse.ArgumentParser(description='Tool to send special mail')
    parser.add_argument('-c', '--config', help='path to configuration json file', required=True)
    args = parser.parse_args()
    run(json.loads(load_file(args.config)))
