#!/usr/bin/python

import argparse
import os
import time

def main():
    descriptionText = 'Check *.status file.\n' \
        'And make output in monrun format.'

    parser = argparse.ArgumentParser(description=descriptionText)
    parser.add_argument('-f', '--file', dest='filename', required=True, action='store',
            help='Filename of *.status file.')
    parser.add_argument('-t', dest='check_file_age', required=False, action='store_true',
            help='Depricated.')
    parser.add_argument('-e', '--err-age-limit', dest='err_age_limit', required=False, action='store',
            type=int, help='Check if file creation time is not older than ERR_AGE_LIMIT minutes.')
    args = parser.parse_args()

    if not os.path.isfile(args.filename):
        print("0;status-file not found")
        return

    if args.err_age_limit:
        age_sec = int(time.time() - os.path.getmtime(args.filename))
        if age_sec > args.err_age_limit * 60:
            print('2;status-file is too old (age={:d} minutes)'.format(int(age_sec/60)))
            return

    with open(args.filename, 'r') as f:
        print(f.readline().rstrip())


if __name__ == '__main__':
    main()
