#!/usr/bin/python
# coding: utf-8

import sys
import subprocess

AMMO_PATTERN='ammo.{0:05d}'


def ammo(template_file, index, x1, y1, x2, y2):
    print template_file, index, x1, y1, x2, y2
    args = ['sed']
    args.append('-e')
    args.append('s/__X1__/' + str(x1) + '/g')
    args.append('-e')
    args.append('s/__Y1__/' + str(y1) + '/g')
    args.append('-e')
    args.append('s/__X2__/' + str(x2) + '/g')
    args.append('-e')
    args.append('s/__Y2__/' + str(y2) + '/g')
    args.append(template_file)
    process = subprocess.Popen(args, stdout=subprocess.PIPE)
    filename = AMMO_PATTERN.format(index)
    with file(filename, "wt") as f:
        for line in process.stdout:
            f.write(line)
    return index + 1


def main(template_file, x1, y1, dx, dy, h_num, v_num, index):
    x2 = x1 + dx * ((v_num - 1) if v_num > 1 else 1)
    y2 = y1
    for i in xrange(h_num):
        index = ammo(template_file, index, x1, y2, x2, y2)
        y2 = y2 + dy
    x2 = x1
    y2 = y1 + dy * ((h_num - 1) if h_num > 1 else 1)
    for i in xrange(v_num):
        index = ammo(template_file, index, x2, y1, x2, y2)
        x2 = x2 + dx


if __name__ == '__main__':
    if len(sys.argv) == 8 or len(sys.argv) == 9:
        main(sys.argv[1],
             float(sys.argv[2]), float(sys.argv[3]),
             float(sys.argv[4]), float(sys.argv[5]),
             int(sys.argv[6]), int(sys.argv[7]),
             int(sys.argv[8]) if len(sys.argv) == 9 else 1)
    else:
        print "Usage: " + sys.argv[0] + " <template-file> <x1> <y1> " + \
              "<delta-x> <delta-y> <x-number> <y-number> [<ammo-index>=1]"
