#pragma once

#include <maps/libs/geolib/include/point.h>
#include <maps/libs/geolib/include/polyline.h>

namespace maps {
namespace wiki {
namespace signals_graph {

struct Edge {
public:
    Edge(const std::vector<geolib3::Point2>& points, size_t weight, int from, int to)
        : polyline(points)
        , weight(weight)
        , from(from)
        , to(to)
    { }

    geolib3::Polyline2 polyline;
    size_t weight;
    size_t width;

    int from;
    int to;
};

} // namespace maps
} // namespace wiki
} // namespace signals_graph
