#include "generate_hypotheses.h"

#include "hypotheses_generator/edge_hypothesis.h"
#include "hypotheses_generator/generate_hyps_from_edges.h"

#include "signal.h"
#include "generator_arguments.h"
#include "generator_parameters.h"
#include "generate_edges_from_tracks.h"

#include <yandex/maps/wiki/common/extended_xml_doc.h>

#include <maps/libs/log8/include/log8.h>

#include <boost/range/algorithm_ext/erase.hpp>

#include <vector>
#include <string>

namespace maps {
namespace wiki {
namespace signals_graph {

namespace {

void filterEdges(
    std::vector<Edge>& edges,
    size_t minWeight
) {
    boost::remove_erase_if(
        edges,
        [&](const Edge& edge) {
            return edge.weight < minWeight || edge.polyline.pointsNumber() == 1;
        }
    );
}

} // namespace

std::vector<EdgeHypothesis> generateHypotheses(
    const std::vector<Signal>& signals,
    const std::string& filenamePrefix,
    const GeneratorParameters& genParams,
    const GeneratorArguments& genArgs,
    const common::ExtendedXmlDoc& configXml,
    bool renderGeoms,
    bool calculateMetric,
    size_t commitId
)
{
    auto edges = generateEdgesFromTracks(
        signals,
        filenamePrefix,
        false
    );

    filterEdges(edges, genParams.minHypothesesWeight());

    INFO() << "Got " << edges.size() << " geometries of raw hypotheses";

    return generateHypothesesFromEdges(
        edges,
        genParams.roadBufferWidth(),
        genParams.graphComparisonCellSpan(),
        maps::geolib3::convertGeodeticToMercator(genArgs.geoBbox()),
        configXml,
        filenamePrefix,
        renderGeoms,
        calculateMetric,
        commitId
    );
}

} // namespace signals_graph
} // namespace wiki
} // namespace maps
