#pragma once

#include <maps/wikimap/mapspro/tools/signals_graph/proto/missing_roads_parameters.pb.h>

#include <maps/libs/geolib/include/bounding_box.h>
#include <maps/libs/geolib/include/conversion.h>
#include <maps/libs/geolib/include/point.h>

#include <maps/libs/common/include/exception.h>
#include <maps/libs/config/include/config.h>

#include <google/protobuf/text_format.h>

#include <util/generic/string.h>

#include <string>
#include <fstream>

namespace maps {
namespace wiki {
namespace signals_graph {

/* Global parameters of the algorithm
 *
 * roadBufferWidth: roads/edges are augmented with buffer of this width in
 * meters to subtract them as polygon geometries from other set of edges.
 *
 * minHypothesesWeight: hypotheses having at least this weight (number of tracks
 * used to construct it) will be returned as a result.
 *
 * signalsLoadBufferMeters: buffer width of the region to load signals from YT
 *
 * graphComparisonCellSpan: maximal size of a cell to divide region into
 */

class GeneratorParameters {
public:
    /**
     * @param filename Path to the configuration file in the protobuf text format
     */
    explicit GeneratorParameters(const std::string& filename) {
        TString protoString;
        protoString.assign(maps::config::readConfigFile(filename).c_str());
        MissingRoadsParameters conf;
        REQUIRE(
            google::protobuf::TextFormat::ParseFromString(protoString, &conf),
            "Could not parse parameters file " << filename
        );

        roadBufferWidth_ = conf.GetRoadBufferWidth();
        minHypothesesWeight_ = conf.GetMinHypothesesWeight();
        signalsLoadBufferMeters_ = conf.GetSignalsLoadBufferMeters();
        graphComparisonCellSpan_ = conf.GetGraphComparisonCellSpan();
    }

    double roadBufferWidth() const { return roadBufferWidth_; }
    size_t minHypothesesWeight() const { return minHypothesesWeight_; }

    double signalsLoadBufferMeters() const {
        return signalsLoadBufferMeters_;
    }

    double graphComparisonCellSpan() const
    {
        return graphComparisonCellSpan_;
    }

private:
    double roadBufferWidth_;
    size_t minHypothesesWeight_;
    double signalsLoadBufferMeters_;
    double graphComparisonCellSpan_;
};

} // namespace signals_graph
} // namespace wiki
} // namespace maps
