#pragma once

#include "difference_result.h"
#include "editor_interaction.h"
#include "../edge.h"

#include <yandex/maps/wiki/common/geom.h>

#include <maps/libs/geolib/include/polyline.h>
#include <maps/libs/geolib/include/bounding_box.h>

#include <vector>

namespace maps {
namespace wiki {
namespace signals_graph {

std::vector<common::Geom> cutCellEdgesGeoms(
    const std::vector<geolib3::Polyline2>& edges,
    const std::vector<size_t>& indices,
    const geolib3::BoundingBox& bbox
);

std::vector<std::vector<std::vector<size_t>>> calculateIndices(
    const Grid& grid,
    const std::vector<geolib3::Polyline2>& gpsEdges
);

/**
 * Performs geometrical difference between two sets of polylines (road segmets)
 *
 * @param from: geometries to be cut
 * @param toSubtract: geometries that are buffered and subtracted from @p from
 * @param width: width of a buffer for @p toSubtract geometries in meters
 */
DifferenceResult geomBufferDifference(
    const std::vector<geolib3::Polyline2>& from,
    const std::vector<geolib3::Polyline2>& toSubtract,
    const Grid& grid,
    double width
);

} // namespace signals_graph
} // namespace wiki
} // namespace maps
