#pragma once

#include <yandex/maps/wiki/common/geom.h>

#include <maps/libs/log8/include/log8.h>

#include <vector>

namespace maps {
namespace wiki {
namespace signals_graph {

struct DifferenceResult {
    std::vector<common::Geom> geometries = {};

    void appendGeometries(
        const std::vector<common::Geom>& other,
        const std::vector<size_t>& cellIndices
    ) {
        for (size_t k = 0; k < other.size(); ++k) {
            if (!other[k].isNull()) {
                if (geometries[cellIndices[k]].isNull()) {
                    geometries[cellIndices[k]] = other[k];
                } else {
                    geometries[cellIndices[k]] =
                        geometries[cellIndices[k]].Union(other[k]);
                }
            }
        }
    }
};

} // namespace signals_graph
} // namespace wiki
} // namespace maps
