#pragma once

#include <maps/libs/geolib/include/conversion.h>
#include <maps/libs/geolib/include/point.h>

#include <yandex/maps/wiki/common/geom.h>

#include <geos/geom/Point.h>

namespace maps {
namespace wiki {
namespace signals_graph {

struct EdgeHypothesis {
    EdgeHypothesis(const common::Geom& geometry, size_t weight)
        : weight(weight)
        , length(geometry.geosGeometryPtr()->getLength())
    {
        auto geosPoint = geometry.geosGeometryPtr()->getCentroid();
        point = {geosPoint->getX(), geosPoint->getY()};
    }

    geolib3::Point2 point;
    size_t weight;
    double length;
};

} // namespace signals_graph
} // namespace wiki
} // namespace maps
