#pragma once

#include "editor_interaction.h"
#include "render.h"
#include "edge_hypothesis.h"

#include <maps/libs/geolib/include/point.h>
#include <maps/libs/geolib/include/polyline.h>
#include <maps/libs/geolib/include/bounding_box.h>

#include <yandex/maps/wiki/common/extended_xml_doc.h>
#include <yandex/maps/wiki/revision/common.h>

#include <fstream>
#include <vector>
#include <string>

namespace maps {
namespace wiki {
namespace signals_graph {

void generateHypothesesFile(
    const std::string& filename,
    std::vector<EdgeHypothesis> hypotheses
);

std::vector<EdgeHypothesis> generateHypothesesFromEdges(
    const std::vector<Edge>& edges,
    double bufferWidth,
    double graphComparisonCellSpan,
    const geolib3::BoundingBox& bbox,
    const common::ExtendedXmlDoc& configXml,
    const std::string& filenamePrefix,
    bool renderGeoms,
    bool calculateMetric,
    revision::DBID commitId = 0
);

} // namespace signals_graph
} // namespace wiki
} // namespace maps
