#pragma once

#include "difference_result.h"
#include "../edge.h"
#include "grid.h"

#include <yandex/maps/wiki/common/geom.h>

#include <maps/libs/geolib/include/polyline.h>

namespace maps {
namespace wiki {
namespace signals_graph {

struct Metrics {
    double inputLength = 0.0;
    double targetLength = 0.0;
    double uncoveredTargetLength = 0.0;
};

Metrics calculateMetrics(
    const std::vector<geolib3::Polyline2>& revisionEdges,
    const std::vector<Edge>& gpsEdges,
    const std::vector<common::Geom>& diffGeometries,
    const Grid& grid
);

void printMetrics(const Metrics& result);

} // namespace signals_graph
} // namespace wiki
} // namespace maps
