#pragma once

#include "../style.h"
#include "../save.h"

#include <yandex/maps/wiki/common/geom.h>

#include <maps/libs/geolib/include/conversion_geos.h>
#include <geos/geom/LineString.h>

#include <geos/geom/MultiLineString.h>

#include <maps/libs/log8/include/log8.h>

#include <ostream>

namespace maps {
namespace wiki {
namespace signals_graph {

void renderEasyView(
    std::ostream& ostr,
    const geolib3::Polyline2& polyline,
    const std::string& description = ""
);

void renderEasyView(
    std::ostream& ostr,
    const geos::geom::MultiLineString* geomPtr,
    const std::string& description = ""
);

void renderEasyView(
    std::ostream& ostr,
    common::ConstGeosGeometryPtr geomPtr,
    geos::geom::GeometryTypeId id,
    const std::string& description = ""
);

void renderGeometriesEasyView(
    std::ostream& file,
    const std::vector<common::Geom>& geoms,
    const std::vector<std::string>& descriptions,
    Style style
);

void renderGeometriesEasyView(
    std::ostream& file,
    const std::vector<common::Geom>& geoms,
    Style style
);

void renderGeometriesEasyView(
    std::ostream& file,
    const std::vector<geolib3::Polyline2>& geoms,
    Style style
);

} // namespace signals_graph
} // namespace wiki
} // namespace maps
