#include "link.h"

namespace maps {
namespace wiki {
namespace signals_graph {

constexpr size_t MINIMAL_CROSS_WEIGHT = 1;

std::vector<Link> generateLinks(
    const std::vector<Track>& tracks,
    const std::vector<Turn>& turns,
    const std::vector<Turn>& clusters
) {
    std::vector<Link> result;

    for (size_t trackId = 0; trackId < tracks.size(); ++trackId) {
        Link link{-1, -1, trackId, 0, 0};

        for (auto posTurn : tracks[trackId].turnIds()) {
            int clusterId = turns[posTurn.second].clusterId;
            int crossId = clusters[clusterId].clusterId;

            if (clusters[clusterId].weight < MINIMAL_CROSS_WEIGHT) {
                continue;
            }

            if (crossId != link.crossFrom) {
                link.crossTo = crossId;
                link.posTo = posTurn.first;

                if (link.crossFrom != -1) {
                    result.push_back(link);
                }

                link.crossFrom = link.crossTo;
                link.posFrom = link.posTo;
            } else {
                link.posFrom = posTurn.first;
            }
        }
    }

    return result;
}

void sortLinks(std::vector<Link>& links) {
    std::sort(
        links.begin(),
        links.end(),
        [](const Link& lhs, const Link& rhs) {
            return lhs.crossFrom < rhs.crossFrom || (
                lhs.crossFrom == rhs.crossFrom && lhs.crossTo < rhs.crossTo
            );
        }
    );
}

} // namespace maps
} // namespace wiki
} // namespace signals_graph

