#pragma once

#include "track.h"
#include "turn.h"

namespace maps {
namespace wiki {
namespace signals_graph {

struct Link {
    int crossFrom;
    int crossTo;
    size_t trackId;
    size_t posFrom;
    size_t posTo;
};

std::vector<Link> generateLinks(
    const std::vector<Track>& tracks,
    const std::vector<Turn>& turns,
    const std::vector<Turn>& clusters
);

void sortLinks(std::vector<Link>& links);

} // namespace maps
} // namespace wiki
} // namespace signals_graph
