#include "read_signals.h"

#include "signal.h"

#include <maps/libs/common/include/exception.h>

#include <boost/lexical_cast.hpp>

#include <string>
#include <fstream>

namespace maps {
namespace wiki {
namespace signals_graph {

std::vector<Signal> readSignals(
    const std::string& filename,
    size_t maxSignals
) {
    std::vector<Signal> result;

    std::ifstream istr(filename);
    std::string line;
    while (std::getline(istr, line) && maxSignals) {
        if (!line.empty()) {
            result.push_back(boost::lexical_cast<Signal>(line));
            maxSignals--;
        }
    }

    if (result.empty()) {
        throw RuntimeError() << "Can't read signals from file: " << filename;
    }

    return result;
}

} // namespace maps
} // namespace wiki
} // namespace signals_graph
