#pragma once

#include "edge.h"
#include "link.h"
#include "track.h"
#include "turn.h"

namespace maps {
namespace wiki {
namespace signals_graph {

std::ostream& printPoint(std::ostream& ostr, maps::geolib3::Point2 point);

void drawTurns(const std::vector<Turn>& turns, std::ofstream& ostr);

void drawEdge(std::ostream& ostr, const Edge& edge);

std::ostream& saveLink(
    std::ostream& ostr, const Link& link, const std::vector<Track>& tracks
);

void drawEdges(std::ostream& ostr, const std::vector<Edge>& edges);

Edge loadEdge(std::istream& istr);

void saveData(
    const std::vector<Track>& tracks,
    const std::vector<Link>& links,
    const std::vector<Edge>& edges,
    std::string linksFilename,
    std::string edgesFilename
);

void drawLinks(
    const std::vector<Link>& links,
    std::ofstream& ostr,
    const std::vector<Track>& tracks
);

} // namespace maps
} // namespace wiki
} // namespace signals_graph
