#include "signal.h"

#include <maps/libs/common/include/exception.h>

#include <boost/algorithm/string.hpp>
#include <boost/algorithm/string/split.hpp>

#include <fstream>
#include <vector>
#include <iomanip>

namespace maps {
namespace wiki {
namespace signals_graph {

std::istream& operator>>(std::istream& istr, Signal& signal) {
    std::string line;
    std::getline(istr, line);

    std::vector<std::string> result;
    boost::split(result, line, boost::is_any_of(" \t"));

    REQUIRE(result.size() >= 6, "Signal should have 6 fields");

    double lon = std::stod(result[0]);
    double lat = std::stod(result[1]);
    signal.geoPoint = {lon, lat};

    signal.averageSpeed = std::stod(result[2]);
    signal.direction = std::stod(result[3]);

    signal.timestamp = std::stoull(result[4]);
    signal.uuid = result[5];

    return istr;
}

std::ostream& operator<<(std::ostream& ostr, const Signal& signal) {
    ostr << std::setprecision(9)
        << signal.geoPoint.x() << '\t'
        << signal.geoPoint.y() << '\t'
        << signal.averageSpeed << '\t'
        << signal.direction << '\t'
        << signal.timestamp << '\t'
        << signal.uuid << std::endl;
    return ostr;
}

} // namespace maps
} // namespace wiki
} // namespace signals_graph
