#pragma once

#include <maps/libs/geolib/include/conversion.h>
#include <maps/libs/geolib/include/direction.h>
#include <maps/libs/geolib/include/point.h>

#include <fstream>

namespace maps {
namespace wiki {
namespace signals_graph {

struct Signal {
    maps::geolib3::Point2 geoPoint;
    double direction; // radians
    double averageSpeed; // meters per second
    size_t timestamp; // seconds since epoch
    std::string uuid;

    maps::geolib3::Point2 mercPoint() const {
        return maps::geolib3::geoPoint2Mercator(geoPoint);
    }
    maps::geolib3::Direction2 getDirection() const {
        return maps::geolib3::Direction2(maps::geolib3::degreesToRadians(direction));
    }
};

std::istream& operator>>(std::istream& istr, Signal& signal);

std::ostream& operator<<(std::ostream& ostr, const Signal& signal);

} // namespace maps
} // namespace wiki
} // namespace signals_graph
