#include "style.h"

namespace maps {
namespace wiki {
namespace signals_graph {

std::ostream& operator<<(std::ostream& ostr, const Style& style) {
    switch (style) {
        case RED: ostr << "red"; break;
        case GREEN: ostr << "green"; break;
        case BLUE: ostr << "blue"; break;
        case YELLOW: ostr << "yellow"; break;
    }
    return ostr;
}

void printLinestyle(const Style& style, std::ostream& ostr) {
    ostr << "!linestyle=" << style << ":2" << std::endl;
}

void printPointstyle(
    const Style& inner,
    const Style& outer,
    std::ostream& ostr,
    size_t width
) {
    ostr << "!pointstyle=" << inner << ":" << outer << ":" << width << std::endl;
}

} // namespace maps
} // namespace wiki
} // namespace signals_graph
