#pragma once

#include "signal.h"

#include <string>
#include <vector>
#include <map>

namespace maps {
namespace wiki {
namespace signals_graph {

class Track {
public:
    Track(std::vector<Signal> points) : points_(std::move(points)) {
    }

    void registerTurn(size_t pos, size_t id) {
        turnIds_[pos] = id;
    }

    const std::string& uuid() const { return uuid_; }
    const std::vector<Signal>& points() const { return points_; }

    const std::map<size_t, size_t> turnIds() const { return turnIds_; }
private:
    std::string uuid_;
    std::vector<Signal> points_;
    std::map<size_t, size_t> turnIds_; // pos to turn
};

} // namespace maps
} // namespace wiki
} // namespace signals_graph
