#pragma once

#include <maps/libs/geolib/include/point.h>
#include <maps/libs/geolib/include/direction.h>
#include <maps/libs/geolib/include/conversion.h>
#include <maps/libs/log8/include/log8.h>

#include <fstream>
#include <vector>

namespace maps {
namespace wiki {
namespace signals_graph {

struct Turn {
    enum Type {
        UP,
        RIGHT,
        DOWN,
        LEFT
    };

    std::string uuid;
    double averageSpeed; // meters per second
    double angle; // radians
    geolib3::Direction2 directionIn;
    geolib3::Direction2 directionOut;
    size_t weight = 1;
    int clusterId = -1;

    geolib3::Point2 mercPoint;
};

} // namespace maps
} // namespace wiki
} // namespace signals_graph
