#pragma once

#include "track.h"
#include "turn.h"

#include <maps/libs/geolib/include/polyline.h>
#include <maps/libs/geolib/include/distance.h>
#include <maps/libs/geolib/include/direction.h>
#include <maps/libs/log8/include/log8.h>

#include <fstream>
#include <vector>

namespace maps {
namespace wiki {
namespace signals_graph {

class Visitor {
public:
    virtual void visitTrack(Track& track) = 0;
};

void visitTracks(std::vector<Track>& tracks, Visitor& visitor);

class TurnVisitor : public Visitor {
public:
    TurnVisitor() { }

    void visitTrack(Track& track) override;

    const std::vector<Turn>& validTurns() { return validTurns_; }

private:

    bool validTurn(const Turn& turn);

    std::vector<Turn> validTurns_;
};

} // namespace maps
} // namespace wiki
} // namespace signals_graph
