LIBRARY()

OWNER(gradksov)

PEERDIR(
    maps/libs/chrono
    maps/libs/config
    maps/libs/geolib
    maps/libs/log8
    maps/libs/tile
    maps/wikimap/mapspro/libs/revision
    maps/wikimap/mapspro/libs/common
    maps/wikimap/mapspro/tools/signals_graph/proto
    mapreduce/yt/client
    contrib/libs/protobuf
    contrib/libs/geos
)

SRCS(
    clustering.cpp
    generate_edges.cpp
    generate_edges_from_tracks.cpp
    generate_hypotheses.cpp
    link.cpp
    load_signals_from_yt.cpp
    load_default_parameters.cpp
    split_into_tracks.cpp
    read_signals.cpp
    save.cpp
    signal.cpp
    style.cpp
    turn_visitor.cpp
    hypotheses_generator/buffer_difference.cpp
    hypotheses_generator/editor_interaction.cpp
    hypotheses_generator/generate_hyps_from_edges.cpp
    hypotheses_generator/grid.cpp
    hypotheses_generator/metrics.cpp
    hypotheses_generator/render.cpp
)

RESOURCE(
    ../config/missing_roads_parameters.conf /wiki-missing-roads-parameters
)

END()
