#include "update_revision_attrs.h"

#include <yandex/maps/wiki/revision/common.h>

#include <maps/libs/common/include/exception.h>
#include <yandex/maps/log/log.h>

#include <boost/algorithm/string/split.hpp>
#include <boost/algorithm/string.hpp>
#include <boost/lexical_cast.hpp>

#include <string>
#include <fstream>
#include <vector>

typedef uint64_t ID;

//const std::string FILENAME =
//    "/home/dicentra/floor.csv";

//const std::string CONN_STRING =
//    "postgresql://mapspro:mapspro@pg93mpro.maps.dev.yandex.net:5432/mapspro_euclid_topofixed";

const maps::wiki::revision::UserID UID = 212955320; // yndx-dicentra

const maps::wiki::revision::Attributes COMMIT_ATTRS =
    {{"description", "update bld heights MAPS-14967"},
     {"action", "group-modified-attributes"}};

const std::string BLD_HEIGHT_ATTR = "bld:height";

const std::string BLD_CATEGORY = "cat:bld";

int main(int argc, char** argv)
{
    if (argc != 3) {
        WARN() << "Usage: tds_update_bld_heights <csv file path> <connstring>";
        return 1;
    }

    AttributesData attrs;

    std::ifstream infile(argv[1]);
    std::string str;
    while (std::getline(infile, str)) {
        std::vector<std::string> parts;
        boost::split(parts, str, [] (char c) -> bool { return c == ','; });
        for (auto& s : parts) {
            boost::trim(s);
        }
        REQUIRE(parts.size() == 2, "Must be two values only: id height");
        ID id = boost::lexical_cast<ID>(parts.front());
        boost::lexical_cast<size_t>(parts.back());
        REQUIRE(attrs.insert({id, Attribute{BLD_HEIGHT_ATTR, parts.back()}}).second,
            "Object " << id << " is already added");
    }

    INFO() << attrs.size() << " bld objects to process";

    updateRevisionAttributes(argv[2], BLD_CATEGORY, attrs, COMMIT_ATTRS, UID);

    return 0;
}
