#include "update_revision_attrs.h"

#include <yandex/maps/wiki/revision/common.h>

#include <maps/libs/common/include/exception.h>
#include <yandex/maps/log/log.h>

#include <string>
#include <fstream>

typedef uint64_t ID;

//const std::string FILENAME = "/home/dicentra/processed_rdel_ids.txt";

//const std::string CONN_STRING =
//    "postgresql://mapspro:mapspro@pg93mpro.maps.dev.yandex.net:5432/mapspro_euclid_topofixed";

const maps::wiki::revision::UserID UID = 212955320; // yndx-dicentra

const maps::wiki::revision::Attributes COMMIT_ATTRS =
    {{"description", "fix srv_processed rd_el attr"}};

const std::string RD_EL_SRV_PROCESSED_ATTR = "rd_el:srv_processed";

const std::string RD_EL_CATEGORY = "cat:rd_el";

int main(int argc, char** argv)
{
    if (argc != 3) {
        WARN() << "Usage: update_rdel_processed <ids file path> <connstring>";
        return 1;
    }

    AttributesData attrs;

    const Attribute processedAttr = {RD_EL_SRV_PROCESSED_ATTR, "1"};

    std::ifstream infile(argv[1]);
    ID id;
    while (infile >> id) {
        attrs.insert({id, processedAttr});
    }

    INFO() << attrs.size() << " rd_el objects to process";

    updateRevisionAttributes(argv[2], RD_EL_CATEGORY, attrs, COMMIT_ATTRS, UID);

    return 0;
}
