#pragma once

#include <yandex/maps/wiki/revision/common.h>

#include <string>
#include <vector>
#include <map>

const size_t BATCH_SIZE = 1000;

struct Attribute {
    std::string name;
    std::string value;
};

typedef std::map<maps::wiki::revision::DBID, Attribute> AttributesData;

struct Options
{
    const bool canOverwrite;
    const bool updateApprovedOnly;
    const bool dryRun;
    const maps::wiki::revision::DBID branchId;
    const size_t batchSize;
};

struct UpdateResult
{
    UpdateResult() : updateCount(0) {}

    std::vector<maps::wiki::revision::DBID> commitIds;
    maps::wiki::revision::DBIDSet draftObjectIds;
    maps::wiki::revision::DBIDSet nonExistentObjectIds;
    size_t updateCount;
};

// Writes created commit ids to log (to run synchronization later if needed)
UpdateResult
updateRevisionAttributes(
    const std::string& connString,
    const std::string& categoryId,
    const AttributesData& attributesData,
    const maps::wiki::revision::Attributes& commitAttributes,
    maps::wiki::revision::UserID updatedBy,
    const Options& options);
