#pragma once

#include "topology_data.h"
#include "utils/geom_helpers.h"


namespace maps {
namespace wiki {
namespace topology_fixer {


class AreaDiffChecker {
public:
    AreaDiffChecker(
            double clipBoxSize,
            double areaDifferenceThreshold,
            size_t threads)
        : clipBoxSize_(clipBoxSize)
        , areaDifferenceThreshold_(areaDifferenceThreshold)
        , threads_(threads)
    {}

    size_t operator () (
        const TopologyData& originalData,
        const TopologyData& fixedData) const;

protected:

    double clipBoxSize_;
    double areaDifferenceThreshold_;
    size_t threads_;
};

class PerimeterDiffChecker {
public:
    PerimeterDiffChecker(
            double clipBoxSize,
            double perimeterDifferenceThreshold,
            size_t threads)
        : clipBoxSize_(clipBoxSize)
        , perimeterDifferenceThreshold_(perimeterDifferenceThreshold)
        , threads_(threads)
    {}

    size_t operator () (
        const TopologyData& originalData,
        const TopologyData& fixedData) const;

protected:

    double clipBoxSize_;
    double perimeterDifferenceThreshold_;
    size_t threads_;
};

} // namespace topology_fixer
} // namespace wiki
} // namespace maps
