#include "cmd_helpers.h"

#include "topology_group.h"

namespace maps {
namespace wiki {
namespace topology_fixer {
namespace cmd {

namespace po = boost::program_options;

// common options

const CmdParam<std::string>& g_helpOption()
{
    static const CmdParam<std::string> opt = {OPT_HELP, "produce help message", boost::none};
    return opt;
}

const CmdParam<std::string>& g_verboseOption()
{
    static const CmdParam<std::string> opt = {OPT_VERBOSE, "verbose output", DEFAULT_LOG_LEVEL};
    return opt;
}

const CmdParam<std::string>& g_connectionOption()
{
    static const CmdParam<std::string> opt = {OPT_CONN, "connection string", boost::none};
    return opt;
}

const CmdParam<std::string>& g_restrictionsConfigOption()
{
    static const CmdParam<std::string> opt = {OPT_RESTRICTIONS_CONFIG, "fixers restrictions settings", boost::none};
    return opt;
}

const CmdParam<std::string>& g_ftGroupOption()
{
    std::stringstream ftGroupDescr;
    ftGroupDescr << "Choose one topology group to be processed" << std::endl
        << "Available groups are: " << std::endl;
    for (const auto& group : topologyGroupsRegistry().allGroups()) {
        ftGroupDescr << group->name() << std::endl;
    }

    static const CmdParam<std::string> opt =
        {OPT_FT_GROUP, ftGroupDescr.str(), boost::none};
    return opt;
}

const CmdParam<size_t>& g_threadsOption()
{
    static const CmdParam<size_t> opt = {OPT_THREADS, "thread pool size", DEFAULT_THREADS};
    return opt;
}

const CmdParam<std::string>& g_schemaOption()
{
    static const CmdParam<std::string> opt = {OPT_SCHEMA, "YMapsDF schema", boost::none};
    return opt;
}

const CmdParam<std::string>& g_sridOption()
{
    static const CmdParam<std::string> opt = {OPT_SRID, "srid", STR_MERCATOR};
    return opt;
}

// topology_fixer options

const CmdParam<std::string>& g_inputSchemaOption()
{
    static const CmdParam<std::string> opt = {OPT_INPUT_SCHEMA, "input YMapsDF schema", boost::none};
    return opt;
}

const CmdParam<std::string>& g_outputSchemaOption()
{
    static const CmdParam<std::string> opt = {OPT_OUTPUT_SCHEMA, "output YMapsDF schema", boost::none};
    return opt;
}

const CmdParam<DBIdType>& g_startYMapsDFIdOption()
{
    static const CmdParam<DBIdType> opt = {OPT_START_YMAPSDF_ID, "YMapsDF id to start new objects with", boost::none};
    return opt;
}

// topology_checker options

const CmdParam<std::string>& g_originalSchemaOption()
{
    static const CmdParam<std::string> opt = {OPT_ORIGINAL_SCHEMA, "original YMapsDF schema", boost::none};
    return opt;
}

const CmdParam<std::string>& g_fixedSchemaOption()
{
    static const CmdParam<std::string> opt = {OPT_FIXED_SCHEMA, "fixed YMapsDF schema", boost::none};
    return opt;
}

const CmdParam<double>& g_boxSizeOption()
{
    static const CmdParam<double> opt = {OPT_BOX_SIZE, "box size for cutting", DEFAULT_BOX_SIZE};
    return opt;
}

const CmdParam<double>& g_areaRelativeDifferenceOption()
{
    static const CmdParam<double> opt = {OPT_AREA_RELATIVE_DIFFERENCE, "area relative difference threshold for a box", DEFAULT_AREA_RELATIVE_DIFFERENCE};
    return opt;
}

const CmdParam<double>& g_perimeterRelativeDifferenceOption()
{
    static const CmdParam<double> opt = {OPT_PERIMETER_RELATIVE_DIFFERENCE, "perimeter relative difference threshold for a box", DEFAULT_PERIMETER_RELATIVE_DIFFERENCE};
    return opt;
}

// max ymapsdf id options

const CmdParam<std::string>& g_maxIdSqlPathOption()
{
    static const CmdParam<std::string> opt = {OPT_MAX_ID_SQL_PATH, "path to the max_id.sql script", YMAPSDF_MAX_ID_SQL_PATH};
    return opt;
}

} // namespace cmd
} // namespace topology_fixer
} // namespace wiki
} // namespace maps
