#pragma once

#include "edges_processing_common.h"
#include "../utils/lineal_edges_intersector.h"

#include <maps/libs/geolib/include/polyline.h>
#include <maps/libs/geolib/include/point.h>
#include <maps/libs/geolib/include/dynamic_geometry_searcher.h>

#include <boost/optional.hpp>

#include <vector>
#include <memory>

namespace maps {
namespace wiki {
namespace topology_fixer {

namespace utils {

struct EdgesFixResult;

} // namespace utils;

class EdgesIntersector :public EdgesProcessor {
public:
    EdgesIntersector(const utils::LinearEdgesIntersectionsFixer::Params& params)
        : EdgesProcessor(
              std::max(params.overlapTolerance, params.maxSnapDistance))
        , params_(params)
    {}

private:
    std::shared_ptr<utils::EdgesFixer> createFixer(utils::TopologyDataProxy& data, FaceLocker& locker) const override
    {
        return std::make_shared<utils::LinearEdgesIntersectionsFixer>(data, locker, params_);
    }

    utils::LinearEdgesIntersectionsFixer::Params params_;
};

} // namespace topology_fixer
} // namespace wiki
} // namespace maps
