#pragma once

#include "../common.h"
#include "../topology_data.h"

namespace maps {
namespace wiki {
namespace topology_fixer {

class EdgesMerger {
public:
    explicit EdgesMerger(size_t maxVerticesCount)
        : maxVerticesCount_(maxVerticesCount)
    {}

    void operator () (TopologyData& data) const;

private:
    void mergeEdges(TopologyData& data,
        const Edge& edge1, const Edge& edge2, NodeId commonNodeId) const;

    size_t maxVerticesCount_;
};

} // namespace topology_fixer
} // namespace wiki
} // namespace maps
