#pragma once

#include "edges_processing_common.h"
#include "../utils/edges_overlaps_fixer.h"

#include <maps/libs/geolib/include/polyline.h>
#include <maps/libs/geolib/include/point.h>
#include <maps/libs/geolib/include/dynamic_geometry_searcher.h>

#include <boost/optional.hpp>

#include <vector>
#include <memory>

namespace maps {
namespace wiki {
namespace topology_fixer {

namespace utils {

struct EdgesFixResult;

} // namespace utils;

class EdgesOverlapper :public EdgesProcessor {
public:
    EdgesOverlapper(double eps, double maxAngleBetweenSegments)
        : EdgesProcessor(eps)
        , eps_(eps)
        , maxAngleBetweenSegments_(maxAngleBetweenSegments)
    {}

private:
    std::shared_ptr<utils::EdgesFixer> createFixer(utils::TopologyDataProxy& data, FaceLocker& locker) const override
    {
        return std::make_shared<utils::EdgesOverlapsFixer>(
            data, locker, eps_, maxAngleBetweenSegments_);
    }

    double eps_;
    double maxAngleBetweenSegments_;
};

} // namespace topology_fixer
} // namespace wiki
} // namespace maps
