#pragma once

#include "../topology_data.h"
#include "../utils/searchers.h"
#include "../utils/edges_fixer.h"

#include <yandex/maps/wiki/threadutils/threadpool.h>

#include <functional>
#include <memory>

namespace maps {
namespace wiki {
namespace topology_fixer {

namespace utils {

struct EdgesFixResult;

} // namespace utils;

class EdgesProcessor {
public:
    EdgesProcessor(double maxInteractingEdgesDistance)
        : maxInteractingEdgesDistance_(maxInteractingEdgesDistance)
    {}

    virtual ~EdgesProcessor() = default;

    void operator()(TopologyData& data, FaceLocker& locker, ThreadPool& pool) const;

protected:
    virtual std::shared_ptr<utils::EdgesFixer> createFixer(utils::TopologyDataProxy&, FaceLocker&) const = 0;

    class EdgesBatch {
    public:
        EdgesBatch(
            utils::TopologyDataProxy& data,
            std::shared_ptr<utils::EdgesFixer> fixer,
            EdgeIdsList edgeIds,
            DynamicEdgeSearcher searcher,
            double maxInteractingEdgesDistance);

        void operator () ()
        {
            try {
                doWork();
            } catch (const maps::Exception& e) {
                ERROR() << e;
                throw;
            } catch (const std::exception& e) {
                ERROR() << e.what();
                throw;
            }
        }

    private:
        void doWork();

        std::pair<EdgeIdsSet, EdgeIdsSet>
        processEdgeInteractions(EdgeId edgeId, EdgeIdsList&& otherEdgeIds);

        void logSplitResult(
            const std::string& fixerName,
            EdgeId edgeId, EdgeId otherEdgeId,
            const utils::EdgesFixResult& splitResult) const;

        utils::TopologyDataProxy& data_;
        std::shared_ptr<utils::EdgesFixer> fixer_;
        EdgeIdsList edgeIds_;
        DynamicEdgeSearcher searcher_;
        double maxInteractingEdgesDistance_;
    };

    void processLastEdgesBatch(
        TopologyData& data,
        FaceLocker& locker,
        ThreadPool& pool,
        const EdgeIdsSet& processedEdgeIds) const;

    double maxInteractingEdgesDistance_;
};

} // namespace topology_fixer
} // namespace wiki
} // namespace maps
