#pragma once

#include "../common.h"
#include "../params.h"
#include "../topology_data.h"
#include "../utils/topology_data_proxy.h"
#include "../utils/searchers.h"
#include "../utils/sync.h"

#include <yandex/maps/wiki/threadutils/threadpool.h>

#include <atomic>

namespace maps {
namespace wiki {
namespace topology_fixer {

class FacesMerger {
public:
    FacesMerger(
            const config::FaceMerging& params,
            TopologyData& data,
            FaceLocker& locker)
        : params_(params)
        , data_(data)
        , faceData_(buildFaceData(data))
        , searcher_(data)
        , locker_(locker)
        , allFaceIds_(data.faceIds())
    {}

    void operator()(ThreadPool& pool);

private:
    struct FaceData {
        geolib3::BoundingBox bbox;
        geolib3::PointsVector points;
    };

    typedef std::unordered_map<FaceId, FaceData> FaceDataMap;

    FaceDataMap buildFaceData(const TopologyData& data) const;

    void processFaces(FaceId faceId, const IdSet& intersectedFaceIds);

    config::FaceMerging params_;
    utils::ThreadSafeTopologyDataProxy data_;
    FaceDataMap faceData_;
    FaceSearcher searcher_;
    FaceLocker& locker_;
    SharedProcessedIdsCache processedIds_;
    FaceIdsVector allFaceIds_;
};

} // namespace topology_fixer
} // namespace wiki
} // namespace maps
