#pragma once

#include "../common.h"
#include "../topology_data.h"
#include "../utils/topology_data_proxy.h"
#include "../utils/searchers.h"
#include "../utils/master_area_holder.h"

#include <atomic>

namespace maps {
namespace wiki {
namespace topology_fixer {

class FeaturesMerger {
public:
    FeaturesMerger(
            size_t maxMasterFacesCount,
            size_t maxFaceEdgesCount,
            double maxFaceBBoxSize,
            size_t threads)
        : maxMasterFacesCount_(maxMasterFacesCount)
        , maxFaceEdgesCount_(maxFaceEdgesCount)
        , maxFaceBBoxSize_(maxFaceBBoxSize)
        , threads_(threads)
    {}

    void operator () (TopologyData& data) const;

private:
    typedef std::atomic<bool> ErrorFlag;

    class EdgesBatch {
    public:
        EdgesBatch(
            utils::TopologyDataProxy& data,
            MasterAreaHolder& masterAreas,
            const OrderedIdSet& edgeIds,
            size_t maxMasterFacesCount,
            size_t maxFaceEdgesCount,
            double maxFaceBBoxSize,
            ErrorFlag& errorFlag);

        void operator () ()
        {
            try {
                doWork();
            } catch (const std::exception& e) {
                ERROR() << e.what();
                errorFlag_ = true;
            }
        }

    private:
        void doWork();

        utils::TopologyDataProxy& data_;
        MasterAreaHolder& masterAreas_;
        OrderedIdSet edgeIds_;
        size_t maxMasterFacesCount_;
        size_t maxFaceEdgesCount_;
        double maxFaceBBoxSize_;
        ErrorFlag& errorFlag_;
    };

    size_t maxMasterFacesCount_;
    size_t maxFaceEdgesCount_;
    double maxFaceBBoxSize_;
    size_t threads_;
};

} // namespace topology_fixer
} // namespace wiki
} // namespace maps
