#pragma once

#include "../common.h"
#include "../topology_data.h"

namespace maps {
namespace wiki {
namespace topology_fixer {

/**
 * Unites nodes (pairwise) if distance between them is less than
 *   @param minNodesDistance.
 * Necessary condition is
 */
class NodesMerger {
public:
    NodesMerger(
            double minNodesDistance,
            double maxRemovableEdgeLength)
        : minNodesDistance_(minNodesDistance)
        , maxRemovableEdgeLength_(maxRemovableEdgeLength)
    {}

    void operator () (TopologyData& data) const;

private:
    double minNodesDistance_;
    double maxRemovableEdgeLength_;
};

} // namespace topology_fixer
} // namespace wiki
} // namespace maps
