#pragma once

#include "../common.h"
#include "../topology_data.h"

namespace maps {
namespace wiki {
namespace topology_fixer {

class SelfOverlappedFacesRemover {
public:
    SelfOverlappedFacesRemover(
            double eps,
            double maxAngle,
            double minAdFaceArea)
        : eps_(eps)
        , maxAngle_(maxAngle)
        , minAdFaceArea_(minAdFaceArea)
    {}

    void operator () (TopologyData& data) const;

private:
    double eps_;
    double maxAngle_;
    double minAdFaceArea_;
};

} // namespace topology_fixer
} // namespace wiki
} // namespace maps
