#pragma once

#include "../common.h"
#include "../topology_data.h"
#include "../utils/sync.h"

#include <yandex/maps/wiki/threadutils/threadpool.h>

namespace maps {
namespace wiki {
namespace topology_fixer {

class HeavyEdgesSplitter {
public:
    explicit HeavyEdgesSplitter(size_t maxVertices)
        : maxVertices_(maxVertices)
    {}

    void operator () (TopologyData& data) const;

private:
    size_t maxVertices_;
};

class EdgesSimplifier {
public:
    explicit EdgesSimplifier(double minSegmentLength)
        : minSegmentLength_(minSegmentLength)
    {}

    void operator()(TopologyData& data, FaceLocker& locker, ThreadPool& pool) const;

private:
    void simplifyEdge(EdgeId edgeId, TopologyData& data, FaceLocker& locker) const;

    double minSegmentLength_;
};

class JunctionsMismatchFixer {
public:

    void operator () (TopologyData& data) const;

};

} // namespace topology_fixer
} // namespace wiki
} // namespace maps
