#pragma once

#include "common.h"
#include "topology_group.h"

namespace maps {
namespace wiki {
namespace topology_fixer {

class TopologyDeleter {
public:
    TopologyDeleter(const std::string& connStr, const std::string& schemaName)
        : connStr_(connStr)
        , schemaName_(schemaName)
    {}

    void deleteTopology(const TopologyGroup& group);

private:
    void deleteFaceMaster(pqxx::work& txn, const TopologyGroup& group);
    void deleteEdgeMaster(pqxx::work& txn, const TopologyGroup& group);
    void deleteFace(pqxx::work& txn, const TopologyGroup& group, const std::string& faceTable);
    void deleteEdge(pqxx::work& txn, const TopologyGroup& group);
    void deleteNode(pqxx::work& txn, const TopologyGroup& group);

    void deleteTopologyImpl(pqxx::work& txn, const TopologyGroup& group);

    std::string connStr_;
    std::string schemaName_;
};

} // namespace topology_fixer
} // namespace wiki
} // namespace maps
