#pragma once

#include "topology_data.h"
#include "params.h"
#include "utils/sync.h"

#include <yandex/maps/wiki/threadutils/threadpool.h>

namespace maps {
namespace wiki {
namespace topology_fixer {

class TopologyFixer {
public:
    TopologyFixer(
            TopologyData& data,
            const config::Restrictions& restrictions,
            size_t threads)
        : data_(data)
        , restrictions_(restrictions)
        , locker_(data)
        , pool_(threads)
        , threads_(threads)
    {}

    void operator () ();

private:
    void removeDegenerateFaces();
    void mergeFaces();
    void fixJunctionsMismatch();
    void splitHeavyEdges();
    void simplifyEdges();
    void mergeCloseNodes();
    void processEdgeInteractions();
    void removeFaceGaps();
    void mergeEdges();
    void mergeFeatures();

    TopologyData& data_;
    const config::Restrictions& restrictions_;
    FaceLocker locker_;
    ThreadPool pool_;
    size_t threads_;
};

} // namespace topology_fixer
} // namespace wiki
} // namespace maps
