#pragma once

#include "topology_data.h"
#include "topology_group.h"

#include <list>
#include <string>

namespace maps {
namespace wiki {
namespace topology_fixer {

class IdGenerator;

class TopologyLoader {
public:
    TopologyLoader(
            const std::string& connStr,
            const std::string& schemaName,
            std::shared_ptr<IdGenerator> gen,
            SRID srid)
        : connStr_(connStr)
        , schemaName_(schemaName)
        , gen_(gen)
        , srid_(srid)
    {}

    TopologyData loadData(const TopologyGroupPtr& group);

private:
    void loadFeatureAttributes(TopologyData& data, pqxx::work& work);

    std::string connStr_;
    std::string schemaName_;
    std::shared_ptr<IdGenerator> gen_;
    SRID srid_;
};

} // namespace topology_fixer
} // namespace wiki
} // namespace maps
