#pragma once

#include "common.h"

namespace maps {
namespace wiki {
namespace topology_fixer {

class TopologyData;

class TopologyUploader {
public:
    TopologyUploader(
            const std::string& connStr,
            const std::string& schemaName,
            const std::string& origSchemaName)
        : connStr_(connStr)
        , conn_(connStr_)
        , schemaName_(schemaName)
        , origSchemaName_(origSchemaName)
    {
        pqxx::work work(conn_);
        work.exec("SET search_path TO " + schemaName_ + ", public");
        work.commit();
    }

    void uploadData(const TopologyData& data);

private:
    void saveFeatures(const TopologyData& data);
    void deleteFeatures(const TopologyData& data);
    void saveFaceMasterRelations(const TopologyData& data);
    void saveEdgeMasterRelations(const TopologyData& data);
    void saveFaces(const TopologyData& data);
    void saveEdges(const TopologyData& data);
    void saveNodes(const TopologyData& data);

    std::string connStr_;
    pqxx::connection conn_;
    std::string schemaName_;
    std::string origSchemaName_;
};

} // namespace topology_fixer
} // namespace wiki
} // namespace maps
